import sprites.utils.*;
import sprites.*;

class Creature{
  
  private int _visibleIdx;
  private ArrayList<CreatureSprite> _creatureStates = new ArrayList<CreatureSprite>();


public Creature(){
  _visibleIdx = -1;  
}

public void addState(CreatureSprite newSprite){
   _creatureStates.add(newSprite);
   if(_visibleIdx == -1){
     _visibleIdx = 0;
     _creatureStates.get(_creatureStates.size() - 1).setVisible(true);
   }else{
     _creatureStates.get(_creatureStates.size() - 1).setVisible(false);
   }
   
   //println(_creatureStates.size());
}

public void setVisibility(int visibleIdx){
  
  _visibleIdx = visibleIdx;
  
  //println(_visibleIdx);
  
  for (int i = 0; i < _creatureStates.size(); i++) {
    if(i == _visibleIdx){
      _creatureStates.get(i).setVisible(true);
      //println("made creature " + i + " visible");
    }else{
       _creatureStates.get(i).setVisible(false);
    }
  }
}



public void update(){
  
  for (int i = 0; i < _creatureStates.size(); i++) {
    
    if(_creatureStates.get(i).getX() <= -250){
      _creatureStates.get(i).setX(_creatureStates.get(i).getX() + imageW);
    }
    _creatureStates.get(i).setX(_creatureStates.get(i).getX() - _creatureStates.get(i).getScrollSpeed());
  }
}

public ArrayList<CreatureSprite> getStates(){
   return _creatureStates;
}


}
